//-------------------------------------------------
//          TestSuite: Multiple
//-------------------------------------------------

#include "lcd.h"
#include "util.h"
#include "os_core.h"
#include "os_scheduler.h"

#include <avr/interrupt.h>

#define DELAY 500


PROGRAM(1, AUTOSTART) {
  uint8_t x;
  for (x = 0; x < 10; x++) {
    cli();
    lcd_writeChar(' ');
    lcd_writeChar('1');
    if (!(x % 5)) {
      os_exec(2, DEFAULT_PRIORITY);
      lcd_writeChar('!');
      lcd_writeChar(';');
    }
    sei();
    delayMs(DELAY);
  }
  for (;;) {
    lcd_writeChar(' ');
    lcd_writeChar('1');
    delayMs(DELAY);
  }
}

PROGRAM(2, AUTOSTART) {
  static char siblings = 'a';
  char whoami = ++siblings;
  for (;;) {
    cli();
    lcd_writeChar(' ');
    lcd_writeChar('2');
    lcd_writeChar(whoami);
    lcd_writeChar(';');
    sei();
    delayMs(DELAY);
  }
}
